/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface IModularMelee
extends IModularTieredItem,
IDraconicMelee {
    default public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        float damage = (float)this.getAttackDamage(host, stack);
        long energyPerHit = (long)((float)EquipCfg.energyAttack * damage);
        this.extractEnergy(player, stack, energyPerHit);
        double aoe = (double)host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe() * 1.5;
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("attack_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getDecimal("attack_aoe").getValue();
        }
        float attackStrength = player.m_36403_(0.5f);
        if (aoe > 0.0 && (double)attackStrength > 0.9) {
            this.dealAOEDamage(player, target, stack, energyPerHit, damage *= 0.2f + attackStrength * attackStrength * 0.8f, aoe);
        }
        return false;
    }

    default public void dealAOEDamage(Player player, Entity target, ItemStack stack, long energyPerHit, float damage, double aoe) {
        List entities = player.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(aoe, 0.25, aoe));
        double aoeAngle = 100.0;
        double yaw = player.m_146908_() - 180.0f;
        int fireAspect = EnchantmentHelper.m_44914_((LivingEntity)player);
        for (LivingEntity entity : entities) {
            if (this.getEnergyStored(stack) < energyPerHit && !player.m_150110_().f_35937_) break;
            float distance = player.m_20270_((Entity)entity);
            if (entity == player || entity == target || player.m_7307_((Entity)entity) || distance < 1.0f || (double)entity.m_20270_(target) > aoe) continue;
            double angle = Math.atan2(player.m_20185_() - entity.m_20185_(), player.m_20189_() - entity.m_20189_()) * 57.29577951308232;
            double relativeAngle = Math.abs((angle + yaw) % 360.0);
            if (relativeAngle <= aoeAngle / 2.0 || relativeAngle > 360.0 - aoeAngle / 2.0) {
                boolean lit = false;
                float health = entity.m_21223_();
                if (fireAspect > 0 && !entity.m_6060_()) {
                    lit = true;
                    entity.m_20254_(1);
                }
                if (entity.m_6469_(entity.m_9236_().m_269111_().m_269075_(player), damage)) {
                    int k;
                    float damageDealt = health - entity.m_21223_();
                    entity.m_147240_((double)0.4f, MathHelper.sin((double)((double)player.m_146908_() * 0.017453292519943)), -MathHelper.cos((double)((double)player.m_146908_() * 0.017453292519943)));
                    if (fireAspect > 0) {
                        entity.m_20254_(fireAspect * 4);
                    }
                    if (player.m_9236_() instanceof ServerLevel && damageDealt > 2.0f) {
                        k = (int)((double)damage * 0.5);
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                    player.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
                    if (player.m_9236_() instanceof ServerLevel && damageDealt > 2.0f) {
                        k = (int)((double)damageDealt * 0.5);
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                } else if (lit) {
                    entity.m_20095_();
                }
            }
            this.extractEnergy(player, stack, energyPerHit);
        }
    }
}

